// -------------  W D I O . D C L  ----------------
// Dialog support file for Spreadsheet --> PLC I/O generator
// utility. 
//
// ** 30-Aug-06 NEHolt; general cleanup
// ** 14-Apr-04 NEHolt; changed phrase "parametric data files" to "parametric data file" (2 places)
// ** 31-Mar-04 LeeH; moved "6th device" from "wdio_dev_dlg" to "wdio_dev_dlg_2nd"
// ** 13-Jan-03 NEHolt; widened some "scroll" maxvalues
// ** 25-Feb-02 ScottH; added arrow style selection
// ** 21-Feb-02 ScottH; added INST attribute mapping selection
// ** 25-Jan-02 NEHolt; added "Scl" edit box on "Ladder config" dialog
// *** 12-Oct-00 PMM added general settings and save/read settings


// ---
wdio_csv_dlg : dialog
  {
  
  label=/*dcl_io_026*/"Spreadsheet to PLC I/O Drawing Generator";

  :list_box{key="lst";width=75;height=9;
           label=/*dcl_io_027*/"Spreadsheet data";
    fixed_width_font = true;}
    
// ** 13-Jan-03 NEHolt widened to allow display of 60 fields each 7 char wide  
//  :slider{key="scroll";min_value=1;max_value=180;small_increment=10;
//         big_increment=10;}
  :slider{key="scroll";min_value=1;max_value=420;small_increment=10;
         big_increment=10;}
// **         

  :spacer{height=1;}
  :row
    {
    
    label=/*dcl_io_028*/"Assign spreadsheet or table column numbers to data categories below";
    fixed_width=false;
    :column
      {
      fixed_height=true;
      alignment=top;
      :row
        {
        fixed_width=true;
        :popup_list{key="plc_code_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_029*/"Module part numbers";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="addr_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_030*/"Address";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="rack_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_031*/"Rack numbers";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="group_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_032*/"Group numbers";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="slot_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_033*/"Slot numbers";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="remote_tp_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_034*/"Remote terminal panel";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="wire_tag_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_035*/"Wire numbers";
             }
        }
      :spacer{height=0;}
      }
// ** 23-May-02 NEHolt      
    :column
      {
      fixed_height=true;
      alignment=top;
      :row
        {
        fixed_width=true;
        :popup_list{key="plc_mod_tag_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_036*/"Module's tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="plc_inst_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_037*/"Module's Installation";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="plc_loc_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_038*/"Module's Location";
             }
        }      
      }
// **        
    :column
      {
      fixed_height=true;
      alignment=top;
      :row
        {
        fixed_width=true;
        :popup_list{key="desc1_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_039*/"Description 1";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="desc2_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_040*/"Description 2";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="desc3_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_041*/"Description 3";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="desc4_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_042*/"Description 4";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="desc5_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_043*/"Description 5";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="volt_ix";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_044*/"Voltage/Input/Output";
             }
        }
      }
    }
  :row
    { 
    fixed_width=false;
    :spacer{width=14;} 
    ok_button;
    cancel_button;
    :row
      {
      fixed_width=true;
      :button{
             label=/*dcl_io_045*/"More";
             key="devices";fixed_width=true;}
      :text{
           label=/*dcl_io_046*/"In-line connected devices";
           }
      }
    }    
  }
// ---
wdio_dev_dlg : dialog
  {
  
  label=/*dcl_io_047*/"Connected device(s)";

  :paragraph
    {
    :text_part{
              label=/*dcl_io_048*/"Your spreadsheet data can define up to nine series-connected devices.";
              }// ** 17-Oct-02 ScottH chnd six to 9
    :text_part{
              label=/*dcl_io_049*/"These are defined on a per input or output point basis.";
              }
    :text_part{
              label="";
              }
    :text_part{
              label=/*dcl_io_050*/"Devices for an input point insert left to right or top to bottom.";
              }
    :text_part{
              label=/*dcl_io_051*/"Output devices insert in reverse order, right to left or bottom to top.";
              }
    }
// *** 26-Aug-00 PMM
  :list_box{key="lst";width=75;height=6;
           label=/*dcl_io_027*/"Spreadsheet data";
    fixed_width_font = true;}
// ** 13-Jan-03 NEHolt widened to allow display of 60 fields each 7 char wide  
//  :slider{key="scroll";min_value=1;max_value=180;small_increment=10;
//         big_increment=10;}
  :slider{key="scroll";min_value=1;max_value=420;small_increment=10;
         big_increment=10;}
// **         
//  :spacer{height=1;}
  :row
    {
    
    label=/*dcl_io_052*/"Assign spreadsheet/table column numbers to device categories below";
    fixed_width=false;
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_053*/"1st device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {// ** 22-Feb-02 SAH
        fixed_width=true;
        :popup_list{key="comp_inst_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix1";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_062*/"2nd device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {// ** 22-Feb-02 SAH
        fixed_width=true;
        :popup_list{key="comp_inst_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix2";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_063*/"3rd device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {// ** 22-Feb-02 SAH
        fixed_width=true;
        :popup_list{key="comp_inst_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix3";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_064*/"4th device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {// ** 22-Feb-02 SAH
        fixed_width=true;
        :popup_list{key="comp_inst_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix4";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_065*/"5th device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {// ** 22-Feb-02 SAH
        fixed_width=true;
        :popup_list{key="comp_inst_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix5";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
    }
    // ** 17-Oct-02 ScottH  added row and 'More' button
  :row
    { 
    fixed_width=false;
    :spacer{width=20;} 
    ok_button;
    cancel_button;
    :row
      {
      fixed_width=true;
      :button{
             label=/*dcl_io_045*/"More";
             key="more_devices";fixed_width=true;}
      :text{
           label=/*dcl_io_067*/"More in-line connected devices";
           }
      }
    } 
    // * * *
  }
// ** 17-Oct-02 ScottH added dialog
wdio_dev_dlg_2nd : dialog
  {
  
  label=/*dcl_io_047*/"Connected device(s)";

  :paragraph
    {
    :text_part{
              label=/*dcl_io_050*/"Devices for an input point insert left to right or top to bottom.";
              }
    :text_part{
              label=/*dcl_io_068*/"Output devices insert in backwards order, right to left, or bottom to top.";
              }
    }
  :list_box{key="lst";width=60;height=6;
           label=/*dcl_io_027*/"Spreadsheet data";
    fixed_width_font = true;}
// ** 13-Jan-03 NEHolt widened    
//  :slider{key="scroll_2";min_value=252;max_value=280;small_increment=10;
//         big_increment=10;}
  :slider{key="scroll_2";min_value=1;max_value=420;small_increment=10;
         big_increment=10;}
// **         
  :row
    {
    
    label=/*dcl_io_052*/"Assign spreadsheet/table column numbers to device categories below";
    fixed_width=false;
// *** 31-Mar-04 LeeH; moved "6th device" from "wdio_gen_dlg"   
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_066*/"6th device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {// ** 22-Feb-02 SAH
        fixed_width=true;
        :popup_list{key="comp_inst_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix6";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
// *** LeeH;      
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_069*/"7th device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_inst_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix7";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_070*/"8th device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_inst_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix8";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
    :column
      {
      fixed_height=true;
      alignment=top;
      :text{
           label=/*dcl_io_071*/"9th device";
           }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_tag_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_054*/"Tag";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_desc_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_055*/"Description";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_blk_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_056*/"Block";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_loc_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_057*/"Location";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_inst_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_058*/"Installation";
             }
        }        
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_mfg_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_059*/"Manufacturer";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_cat_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_060*/"Catalog";
             }
        }
      :row
        {
        fixed_width=true;
        :popup_list{key="comp_asm_ix9";width=1;fixed_width=true;}
        :text{
             label=/*dcl_io_061*/"Assembly";
             }
        }
      :spacer{height=0;}
      }
     
    }
  ok_cancel;
  }  


// ----- *** 28-Sep-99 PMM
wdio_notfound : dialog
  {
  
  label=/*dcl_io_143*/"Module(s) Not Found";
  :list_box{key="notfound";height=6;fixed_height=true;}
  :paragraph
    {
    :text_part{
              label=/*dcl_io_144*/"One or more modules could not be found in the PLC database file.";
              }
    :text_part{
              label=/*dcl_io_145*/"These modules will be skipped (leaving blank columns) if you continue.";
              }
    }
  :row
    {
    alignment=centered;
    fixed_width=true;
    :button{
           label=/*dcl_io_146*/"Continue";
           key="accept";is_default=true;fixed_width=true;}
    :spacer{width=2;}
    :button{
           label=/*dcl_io_147*/"Quit";
           key="cancel";fixed_width=true;is_cancel=true;} // *** 15-Jun-01 PMM
    }
  }
// -- *** 21-Feb-00 PMM
ins_file2tab_which : dialog
  {
  
  label=/*dcl_io_148*/"Table insert";
  :paragraph
    {
    :text_part{
              label=/*dcl_io_149*/"Multiple sheets/tables found in the data file.";
              }
    :text_part{
              label=/*dcl_io_150*/"Choose the one to process.";
              }
    }
  :list_box{key="lst";width=48;height=15;allow_accept=true;}
  ok_cancel;
  }
// -- 21-Feb-00 NEHolt
wdio_ins_template : dialog
  {
  
  label=/*dcl_io_151*/"Template/Prototype - 1st drawing?";
  :paragraph
    {
    :text_part{
              label=/*dcl_io_152*/"If this starting drawing does not have your template inserted,";
              }
    :text_part{
              label=/*dcl_io_153*/"do you want to insert it now?";
              }
    :text_part{
              label="";
              }
    }
  :row
    {
    fixed_width=true;
    alignment = centered;
    ok_button;
    :button{
           label=/*dcl_io_154*/" Skip ";
           width=6;key="no";is_cancel=true;}
    }
  }

// -- ** 18-Mar-04 NEHolt           
wdio_nodata_found : dialog
  {
  label=/*dcl_io_155*/"No data found";
  :paragraph
    {
    :text_part {
               label=/*dcl_io_156*/"No PLC data was processed."; 
               }
    :text_part {
               label=/*dcl_io_157*/"No valid module part numbers found in the database file.";
               }
    :text_part {label="";}
    :text_part {
               label=/*dcl_io_158*/"Possible solution:";
               }           
    :text_part {
               label=/*dcl_io_159*/"Check the column number assigned to the \"Module part numbers\" entry";
               }
    :text_part {
               label=/*dcl_io_160*/"under the \"Spreadsheet/Table columns\" setup dialog.";
               }                        
    }
    cancel_button;
  }           
  
// -------- ** 22-Aug-06 NEHolt
wdio_main : dialog
  {
  label=/*dcl_io_161*/"Spreadsheet to PLC I/O Utility";
  :spacer{height=0;}
  :row
    {
    key="setfnam_x";
    fixed_width=false;
    :edit_box{key="setfnam";edit_max=255;fixed_width=false;
              label=/*dcl_io_162*/"Settings:";
             }
    :row
      {
      fixed_width=true;         
      :button{key="wdi_browse";fixed_width=true;
              label=/*dcl_io_163*/"Browse...";
              }
      :button{key="ldr_setup";fixed_width=true;
              label=/*dcl_io_164*/"Setup";
              }
      }        
    }
  :row
    {
    fixed_width=true;
    :spacer{width=1;}  
    :paragraph
      {
      :text_part{key="setfnam1";width=90;}
      :text_part{key="setfnam2";width=90;}
      }
    }  
  :boxed_column
    {
    label=/*dcl_io_165*/"Ladder Reference Numbering"; 
    :row
      {
      fixed_width=false;
      :column
        {
        fixed_height=true;
        alignment = top;
        :edit_box{key="firstaddr";edit_width=12;allow_accept=true;fixed_width=true;                 
                  label=/*dcl_io_166*/"Start:";
                 }
        :edit_box{key="indx";edit_width=3;fixed_width=true;
                 label=/*dcl_io_118*/"Index:";
                 }
        }  
      :spacer{width=1;}      
      :column
        {
         
        :text{
             label=/*dcl_io_121*/"Column to column";
             }
        :radio_button{key="colcont";
                     label=/*dcl_io_122*/"Next sequential number";
                     }
        :row
          {
          fixed_width=true;
          :radio_button{key="colskip";
                       label=/*dcl_io_123*/"Column to column count:";
                       }
          :edit_box{key="colskipcnt";width=3;is_enabled=false;}
          }
        :spacer{height=0;}
        :text{
             label=/*dcl_io_124*/"Drawing to drawing";
             }
        :radio_button{key="cont";
                     label=/*dcl_io_122*/"Next sequential number";
                     }
        :row
          {
          fixed_width=true;
          :radio_button{key="skip";
                       label=/*dcl_io_125*/"Drawing to drawing count:";
                       }
          :edit_box{key="skipcnt";width=3;is_enabled=false;}
          }
        }
      } 
    :spacer{height=0;}  
    }  
    
  :boxed_column
    {
    label=/*dcl_io_182*/"Module Placement";
    :radio_button{key="start_at_top";
                 label=/*dcl_io_138*/"Always start at top of ladder";
                 }
    :radio_button{key="fit_module";
                 label=/*dcl_io_139*/"Same ladder only if module fits";
                 }
    :row
      {     
      fixed_width=true;              
      :radio_button{key="split_module";
                   label=/*dcl_io_140*/"Fill ladder - allow module splits";
                   }
      :edit_box{key="mod_2_mod_spacing";
                label=/*dcl_io_167*/"Rungs between:";
                edit_width=3;
                fixed_width=true;
                }
      }    
    :row
      {
      fixed_width=true;
      :spacer{width=1;}
      :column
        {                              
        :toggle{key="i_unused";
               label=/*dcl_io_126*/"Include unused/extra connections";
               }
        :toggle{key="predef_brks";
               label=/*dcl_io_168*/"Allow pre-defined breaks";
               }                          
        }       
      }  
    }  
     
  :boxed_column
    {
    label=/*dcl_io_169*/"Drawing File Creation";
    :toggle{key="sfn_active";
           label=/*dcl_io_181*/"Use active drawing";
           } 
    :column
      {
      key="fcreate_x";
      :row
        {
        fixed_width=false;
        :edit_box{key="start_fnam";edit_max=255;
                 label=/*dcl_io_180*/"Starting file name:";
                 }
        :button{key="sfn_browse";fixed_width=true;
               label=/*dcl_io_163*/"Browse...";
               }
        }
      :row
        {
        fixed_width=true;
        :spacer{width=1;}  
        :paragraph  
          {
          :text_part{key="startpath1";width=90;}
          :text_part{key="startpath2";width=90;}
          }
        }  
      }  
//    :spacer{height=0;}
    :row
      {
      fixed_width=false; 
      :row
        {
        fixed_width=true;                  
        :radio_button{key="b_pause";
                     label=/*dcl_io_129*/"Pause between drawings";
                     }
        :radio_button{key="b_nopause";
                     label=/*dcl_io_130*/"Free run";
                     }
        }             
      :edit_box{key="sheet";edit_width=3;fixed_width=true;
                   label=/*dcl_io_170*/"Sheet:";
                   }
      :spacer{width=0;}             
      } 
    :toggle{key="add2proj";fixed_width=true;
           label=/*dcl_io_182*/"Add new drawings to active project";  
           }
    }
  :row
    {
    fixed_width=true;
    alignment = centered;
    :button{
           label=/*dcl_io_171*/" Save ";
           key="save_wdi_1";fixed_width=true;}
    :spacer{width=10;}       
    :button{
           label=/*dcl_io_131*/" Start ";
           key="accept";is_default = true; fixed_width=true;}
    cancel_button;
    help_button;
    :spacer{width=10;} 
    }
  }  

// ------- ** 22-Aug-06 NEHolt
wdio_setup : dialog
  {
  label=/*dcl_io_172*/"Spreadsheet to PLC I/O Utility Setup";
  :spacer{height=0;}  
  :row
    {
    :boxed_column
      {
      fixed_height = true;
      alignment = top;
      label=/*dcl_io_173*/"Ladder";      
      :row
        {
        :column
          {
          fixed_height=true;
          alignment=top;          
          :text{
               label=/*dcl_io_073*/"Origin:";
               }
          :button{
                 label=/*dcl_io_074*/"Pick>>";
                 key="pick";fixed_width=true;alignment=right;}
          :edit_box{
                   label=/*dcl_io_075*/"X:";
                   key="pickx";}
          :edit_box{
                   label=/*dcl_io_076*/"Y:";
                   key="picky";}          
          }
        :spacer{width=1;}  
        :column
          {
          fixed_height = true;          
          alignment = top;
          :text{
               label=/*dcl_io_077*/"Orientation:";
               }
          :image_button{key="ldr_i";height=4.5;color=0;aspect_ratio=1.3;
                        fixed_width=true;fixed_height=true;}
          :radio_button{key="ladr_h_rungs";
                       label=/*dcl_io_078*/"Vertical";
                       }
          :radio_button{key="ladr_v_rungs";
                       label=/*dcl_io_079*/"Horizontal";
                       }
          
          }
        }
      :text{
           label=/*dcl_io_174*/"Reference numbers:";
           }
      :popup_list{key="refnums";fixed_width=false;
                  list=/*dcl_io_175*/"Numbers Only\nNumbers Ruling\nUser Blocks\nX-Y Grid\nX Zones";} 
      :spacer{height=0;}      
      :row
        {
        fixed_width=false;
        :text{
             label=/*dcl_io_097*/"Width:";
             }
        :edit_box{key="ldrwdt";width=5;fixed_width=true;}
        }
      :row
        {
        fixed_width=false;
        :text{
             label=/*dcl_io_098*/"Distance between:";
             }
        :edit_box{key="ldr2ldr";width=5;fixed_width=true;}
        }
      :row
        {
        fixed_width=false;
        :text{
             label=/*dcl_io_080*/"Ladders per drawing:";
             }
        :popup_list{key="numldrs";width=1;
           list="1\n2\n3\n4\n5\n6";fixed_width=true;}
        }
      :row
        {
        fixed_width=false;
        :text{
             label=/*dcl_io_081*/"Rungs per ladder:";
             }
        :edit_box{key="rungcnt";width=5;fixed_width=true;}
        }
      :row
        {
        fixed_width=false;
        :text{
             label=/*dcl_io_082*/"Rung spacing:";
             }
        :edit_box{key="vertsp";width=5;fixed_width=true;}
        }
      :row
        {
        fixed_width=false;
        :text{
             label=/*dcl_io_105*/"Rung count skip for I/O start:";
             }
        :edit_box{key="ydown";width=5;fixed_width=true;}
        }
      :spacer{height=0;}  
      :text{label=/*dcl_io_106*/"Suppression:";}
      :row
        {
        :column{:spacer{width=0;}}          
        :column
          {          
          :toggle{key="suppress_rungs";
                 label=/*dcl_io_107*/"Rungs";
                 }
          :toggle{key="suppress_rails";
                 label=/*dcl_io_108*/"Side bus rails";
                 }       
          :toggle{key="keep_shorted";
                 label=/*dcl_io_109*/"Do not erase unused, blank rungs";
                 }  
        } }
      :row
        {
        fixed_width=false;
        :text{
             label=/*dcl_io_085*/"Signal arrow style:";
             }
        :popup_list{key="arrow_style";width=1;
           list="1\n2\n3\n4\n5\n6\n7\n8\n9";fixed_width=true;}
        }          
      :spacer{height=0;}  
      }
    :column
      {
      fixed_height=true;
      alignment=top;
      :boxed_column
        {
        label=/*dcl_io_176*/"Module";        
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_084*/"PLC graphical style:";
               }
          :popup_list{key="plc_style";width=1;
             list="1\n2\n3\n4\n5\n6\n7\n8\n9";fixed_width=true;}
          }
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_100*/"Input offset from neutral:";
               }
          :edit_box{key="ixoff";edit_width=7;fixed_width=true;}
          }
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_101*/"Output offset from hot bus:";
               }
          :edit_box{key="oxoff";edit_width=7;fixed_width=true;}
          }        
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_099*/"Maximum I/O per ladder:";
               }
          :edit_box{key="maxpnts";edit_width=7;fixed_width=true;}
          }
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_083*/"I/O point spacing:";
               }
          :edit_box{key="usr_rv";width=5;fixed_width=true;}
          }    
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_087*/"Scale:";
               fixed_width=true;}
          :edit_box{key="plcscl";edit_width=7;fixed_width=true;}
          }
        :row
          {
          fixed_width=false;
          :spacer{width=0;}  
          :radio_button{key="scl_1";
                       label=/*dcl_io_088*/"1.0";
                       }
          :radio_button{key="scl_16";
                       label=/*dcl_io_089*/"16";
                       } 
          :radio_button{key="scl_i2m";
                       label=/*dcl_io_090*/"25.4";
                       }
          :radio_button{key="scl_m2i";
                       label=/*dcl_io_091*/"0.039";
                       }
          :spacer{width=0;}             
          }  
        :row
          {
          fixed_width=true;
          :toggle{
                 label=/*dcl_io_092*/"Apply this scale to module outline only";
                 key="scl_borderonly";}                              
          }
        :spacer{height=0;}          }
      :boxed_column
        {
        label=/*dcl_io_177*/"In-Line Devices";        
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_102*/"First input device from hot bus:";
               }
          :edit_box{key="idoff";width=5;fixed_width=true;}
          }
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_103*/"First output device from neutral bus:";
               }
          :edit_box{key="odoff";width=5;fixed_width=true;}
          }
        :row
          {
          fixed_width=false;
          :text{
               label=/*dcl_io_104*/"Spacing between multiple devices:";
               }
          :edit_box{key="multi_x";width=5;fixed_width=true;}
          }
        :spacer{height=0;}  
        }
      :button{key="ss_columns";fixed_width=true;alignment=centered;
        label=/*dcl_io_178*/"Spreadsheet/Table Columns";
        }
      :text{
           label=/*dcl_io_179*/"Drawing template:";
           }
      :row
        {
        fixed_width=false;
        :edit_box{key="template";edit_width=40;edit_max=255;}
        :button{key="template_browse";fixed_width=true;
                label=/*dcl_io_163*/"Browse...";
               }                       
        }
// ** 27-Jul-07 NEHolt - 958228 
      // add room to show full path to template file
      :paragraph
        { 
        :text_part{key="template1";width=50;}
        :text_part{key="template2";width=50;}
        }    
// ** 27-Jul-07 NEHolt.end        
      }  
    }
  :row
    {
    fixed_width=true;
    alignment = centered;
    :button{
           label=/*dcl_io_171*/" Save ";
           key="save_wdi_2";fixed_width=true;}
    :spacer{width=5;} 
// ** 22-Sep-06 NEHolt make cancel look like OK so that picking on "X" in upper-right will dismiss dlg 
    :retirement_button{key="cancel";fixed_width=true;
                       label="OK";                        
                       is_cancel=true;is_default=true;}                                
    :spacer{width=5;}                   
// ** 22-Sep-06 NEHolt.en    
    help_button; 
    :spacer{width=5;}
    }
  }